'==========================================================================
'
' NAME: FolderPermissions.vbs
'
' COMMENT: 	This vbscrpt file contains methods using WMI to 
'			set folder and share permissions
'
'***********************************************************************
' THIS CODE AND INFORMATION IS PROVIDED TO YOU FOR YOUR REFERENTIAL 
' PURPOSES ONLY, AND IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
' EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED 
' WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE, 
' AND MAY NOT BE REDISTRIBUTED IN ANY MANNER.
' 
' Copyright (c) Microsoft Corporation.  All rights reserved.
'***********************************************************************
'
'==========================================================================

'Constants for setting permissions
'Security Descriptor Control Flag constant
const SE_DACL_PRESENT = &h4
'AceType constants
const ACCESS_ALLOWED_ACE_TYPE = &h0
const ACCESS_DENIED_ACE_TYPE  = &h1
'AccessMask Constants
const FILE_ALL_ACCESS         = &h1f01ff
const FOLDER_ADD_SUBDIRECTORY = &h000004
const FILE_DELETE             = &h010000
const FILE_DELETE_CHILD       = &h000040
const FOLDER_TRAVERSE         = &h000020
const FILE_READ_ATTRIBUTES    = &h000080
const FILE_READ_CONTROL       = &h020000
const FOLDER_LIST_DIRECTORY   = &h000001
const FILE_READ_EA            = &h000008
const FILE_SYNCHRONIZE        = &h100000
const FILE_WRITE_ATTRIBUTES   = &h000100
const FILE_WRITE_DAC          = &h040000
const FOLDER_ADD_FILE         = &h000002
const FILE_WRITE_EA           = &h000010
const FILE_WRITE_OWNER        = &h080000

'AceFlags constants
const OBJECT_INHERIT_ACE 	  = &h1
const CONTAINER_INHERIT_ACE	  = &h2
const NO_PROPAGATE_INHERIT_ACE= &h4
const INHERIT_ONLY_ACE		  = &h8
const INHERITED_ACE			  = &h10

'File share constants
Const FILE_SHARE 			  =&h0
Public Function SetCustomerContentPermissions(strPath,strAGroup,strISam,strComputer,strDomain)
'============================================================================
'	NAME:	SetCustomerContentPermissions
'	INPUTS:	strPath - Path to to level customer folder
'			strAdminGroup - name of the admin group
'			strUserGroup - Name of the IUSR_ account
'	OUPUT:	Return Code
'	COMMENTS: This sets the permissions on the customer content
'				directories.
'============================================================================
'	declare variables
	'Dim strComputer
	Dim objWMI
	Dim oWmiLocal
	Dim objFolder
	Dim objSD
	Dim objAceAdminGroup
	Dim objAceSystem
	Dim objAceUserGroup
	Dim nAccessMask
	Dim nAceFlags
	Dim nReturn
	Dim stdErr
	'Dim strLocalPath
	'Dim strDomain
	
	
	'Fetch an instance of the Root WMi Namespace on the remote or local computer
	Set objWMI = CreateWMIServiceInstance(strComputer)
	'================CUT
	'We also need to create a connnect to the local computer 
	'the script is running on.
	'It is the only way to fetch certain things
	'Set oWmiLocal = CreateWMIServiceInstance(".")
	'Fetch the domain name
	'strDomain = oNet.UserDomain
	'Get the names of the groups with the 'cn=' prefix
	'strUserGroup = Right(oUGroup.name,Len(oUGroup.name)-3)
	'strAdminGroup = Right(oAGroup.name,Len(oAGroup.name)-3)
	'Check to see if we are setting permissions over a UNC share
	' If strShare <> "" Then
' 		'Now we have to find the local path to the share
' 		strLocalPath = GetShareLocalPath(strShare,objWMI)
' 		Write oLogFile,strLocalPath,err_info,bDebug
' 		Set objFolder = GetFolderObject(strLocalPath & "\" & strPath,objWMI)
' 	Else
		'Fetch an instance of the Folder Security Settings
	Set objFolder = GetFolderObject(strPath,objWMI)
	'End If
	'Fetch the Security Descriptor of the folder
	Set objSD = GetSecDesc(objFolder)
	'Create the ACEs for the DACL
	'Get computer name
	'strComputer = oNet.ComputerName
	'Set Perms for UserGroup
	nAccessMask = FOLDER_TRAVERSE + FOLDER_LIST_DIRECTORY + FILE_READ_ATTRIBUTES + FILE_READ_EA + FILE_READ_CONTROL + FILE_SYNCHRONIZE
	nAceFlags = OBJECT_INHERIT_ACE + CONTAINER_INHERIT_ACE
	Set objAceIuser = CreateAce(objWMI,strISam,strDomain,nAccessMask,nAceFlags)
	Set objAceAdminGroup=CreateAce(objWMI,strAGroup,strDomain,nAccessMask,nAceFlags)
	objSD.DACL = Array(objAceIuser,objAceAdminGroup)
	'Set the new security descriptor on the folder
	'WScript.Echo "I'm Here"
	nReturn = objFolder.SetSecurityDescriptor(objSD)
	If nReturn <> 0 Then
		strErr = "SetSecurityDescriptor failed with following error code: " 
		Select Case nReturn
			Case 2
				strErr = strErr & nReturn & " : Access Denied"
			Case 8
				strErr = strErr & nReturn & " : Unknown Failure"
			Case 9
				strErr = strErr & nReturn & " : Privilege Missing"
			Case 21
				strErr = strErr & nReturn & " : Invalid Parameter"
		End Select
		Write oLogFle,stdErr,Err_FAIL,bDebug
		Finalize oLogFile, tStart
		WScript.Quit
	End If
	'Now, add Modify permissions to the Web directory for Admins
	'If strShare <> "" Then
	'	Set objFolder = GetFolderObject(strLocalPath & "\" & strPath,objWMI)
	'Else
		'Fetch an instance of the Folder Security Settings
	Set objFolder = GetFolderObject(strPath,objWMI)
	'End If	'Fetch the Security Descriptor of the folder
	Set objSD = GetSecDesc(objFolder)
	nAccessMask = FOLDER_TRAVERSE + FOLDER_LIST_DIRECTORY + FILE_READ_ATTRIBUTES + FILE_READ_EA + FILE_READ_CONTROL + FILE_SYNCHRONIZE + FOLDER_ADD_SUBDIRECTORY + FILE_DELETE + FILE_WRITE_ATTRIBUTES + FILE_WRITE_EA + FOLDER_ADD_FILE
	nAceFlags = OBJECT_INHERIT_ACE + CONTAINER_INHERIT_ACE
	Set objAceAdminGroup=CreateAce(objWMI,strAGroup,strDomain,nAccessMask,nAceFlags)
	objSD.DACL = Array(objAceIuser,objAceAdminGroup)
	'Set the new security descriptor on the folder
	nReturn = objFolder.SetSecurityDescriptor(objSD)
	If nReturn <> 0 Then
		strErr = "SetSecurityDescriptor failed with following error code: " 
		Select Case nReturn
			Case 2
				strErr = strErr & nReturn & " : Access Denied"
			Case 8
				strErr = strErr & nReturn & " : Unknown Failure"
			Case 9
				strErr = strErr & nReturn & " : Privilege Missing"
			Case 21
				strErr = strErr & nReturn & " : Invalid Parameter"
		End Select
		Write oLogFle,stdErr,Err_FAIL,bDebug
		Finalize oLogFile, tStart
		WScript.Quit
	End If
	SetCustomerContentPermissions = nReturn	
End Function

Public Function SetCustomerContentPermissionsFPSE(strPath,oAGroup,oUGroup,oIusr,oUusr,strComputer,strShare)
'============================================================================
'	NAME:	SetCustomerContentPermissions
'	INPUTS:	strPath - Path to to level customer folder
'			strAdminGroup - name of the admin group
'			strUserGroup - Name of the IUSR_ account
'	OUPUT:	Return Code
'	COMMENTS: This sets the permissions on the customer content
'				directories.
'============================================================================
'	declare variables
	'Dim strComputer
	Dim objWMI
	Dim oWmiLocal
	Dim objFolder
	Dim objSD
	Dim objAceAdminGroup
	Dim objAceSystem
	Dim objAceUserGroup
	Dim objAceIuser
	Dim objAceUuser
	Dim nAccessMask
	Dim nAceFlags
	Dim nReturn
	Dim stdErr
	Dim strLocalPath
	Dim strDomain
	Dim strUserGroup
	Dim strAdminGroup
	Dim strIuser
	Dim strUuser
	
	
	'Fetch an instance of the Root WMi Namespace on the remote or local computer
	Set objWMI = CreateWMIServiceInstance(strComputer)
	'We also need to create a connnect to the local computer 
	'the script is running on.
	'It is the only way to fetch certain things
	Set oWmiLocal = CreateWMIServiceInstance(".")
	'Fetch the domain name
	strDomain = oNet.UserDomain
	'Get the names of the groups with the 'cn=' prefix
	strUserGroup = Right(oUGroup.name,Len(oUGroup.name)-3)
	strAdminGroup = Right(oAGroup.name,Len(oAGroup.name)-3)
	strIuser = Right(oIusr.name,Len(oIusr.name)-3)
	strUuser = Right(oUusr.name,Len(oUusr.name)-3)
	'Check to see if we are setting permissions over a UNC share
	If strShare <> "" Then
		'Now we have to find the local path to the share
		strLocalPath = GetShareLocalPath(strShare,objWMI)
		Write oLogFile,strLocalPath,err_info,bDebug
		Set objFolder = GetFolderObject(strLocalPath & "\" & strPath,objWMI)
	Else
		'Fetch an instance of the Folder Security Settings
		Set objFolder = GetFolderObject(strPath,objWMI)
	End If
	'Fetch the Security Descriptor of the folder
	Set objSD = GetSecDesc(objFolder)
	'Create the ACEs for the DACL
	'Get computer name
	'strComputer = oNet.ComputerName
	'Set Perms for UserGroup
	nAccessMask = FOLDER_TRAVERSE + FOLDER_LIST_DIRECTORY + FILE_READ_ATTRIBUTES + FILE_READ_EA + FILE_READ_CONTROL + FILE_SYNCHRONIZE
	nAceFlags = OBJECT_INHERIT_ACE + CONTAINER_INHERIT_ACE
	Set objAceUserGroup = CreateAce(oWmiLocal,oUGroup.SamAccountName,strUserGroup,strDomain,nAccessMask,nAceFlags)
	Set objAceIuser = CreateAce(oWmiLocal,oIusr.SamAccountName,strIuser,strDomain,nAccessMask,nAceFlags)
	Set objAceUuser = CreateAce(oWmiLocal,oUusr.SamAccountName,strUuser,strDomain,nAccessMask,nAceFlags)
	Set objAceAdminGroup=CreateAce(oWmiLocal,oAGroup.SamAccountName,strAdminGroup,strDomain,nAccessMask,nAceFlags)
	objSD.DACL = Array(objAceUserGroup,objAceAdminGroup,objAceIuser,objAceUuser)
	'Set the new security descriptor on the folder
	'WScript.Echo "I'm Here"
	nReturn = objFolder.SetSecurityDescriptor(objSD)
	If nReturn <> 0 Then
		strErr = "SetSecurityDescriptor failed with following error code: " 
		Select Case nReturn
			Case 2
				strErr = strErr & nReturn & " : Access Denied"
			Case 8
				strErr = strErr & nReturn & " : Unknown Failure"
			Case 9
				strErr = strErr & nReturn & " : Privilege Missing"
			Case 21
				strErr = strErr & nReturn & " : Invalid Parameter"
		End Select
		Write oLogFle,stdErr,Err_FAIL,bDebug
		Finalize oLogFile, tStart
		WScript.Quit
	End If
	'Now, add Modify permissions to the Web directory for Admins
	If strShare <> "" Then
		Set objFolder = GetFolderObject(strLocalPath & "\" & strPath,objWMI)
	Else
		'Fetch an instance of the Folder Security Settings
		Set objFolder = GetFolderObject(strPath,objWMI)
	End If	'Fetch the Security Descriptor of the folder
	Set objSD = GetSecDesc(objFolder)
	nAccessMask = FOLDER_TRAVERSE + FOLDER_LIST_DIRECTORY + FILE_READ_ATTRIBUTES + FILE_READ_EA + FILE_READ_CONTROL + FILE_SYNCHRONIZE + FOLDER_ADD_SUBDIRECTORY + FILE_DELETE + FILE_WRITE_ATTRIBUTES + FILE_WRITE_EA + FOLDER_ADD_FILE
	nAceFlags = OBJECT_INHERIT_ACE + CONTAINER_INHERIT_ACE
	Set objAceAdminGroup=CreateAce(oWmiLocal,oAGroup.SamAccountName,strAdminGroup,strDomain,nAccessMask,nAceFlags)
	objSD.DACL = Array(objAceUserGroup,objAceAdminGroup,objAceIuser,objAceUuser)
	'Set the new security descriptor on the folder
	nReturn = objFolder.SetSecurityDescriptor(objSD)
	If nReturn <> 0 Then
		strErr = "SetSecurityDescriptor failed with following error code: " 
		Select Case nReturn
			Case 2
				strErr = strErr & nReturn & " : Access Denied"
			Case 8
				strErr = strErr & nReturn & " : Unknown Failure"
			Case 9
				strErr = strErr & nReturn & " : Privilege Missing"
			Case 21
				strErr = strErr & nReturn & " : Invalid Parameter"
		End Select
		Write oLogFle,stdErr,Err_FAIL,bDebug
		Finalize oLogFile, tStart
		WScript.Quit
	End If
	SetCustomerContentPermissionsFPSE = nReturn	
End Function







Public Function CreateWMIServiceInstance(strComputer)
'===================================================
'	NAME:	CreateWMIServiceInstance
'	IN:		strComputer - Name of computer to connect to
'	OUT:	Instance of WMI \ROOT\CMIV2 namespace
'	
'===================================================
	Dim objWMIService 
	'Create the service setting impersonation level
	'to use the credentials of the caller
	'and authentication level to encrypt COM packets for remote calls
	Set objWMIService = GetObject("winmgmts:{impersonationLevel=impersonate" & _
	",authenticationLevel=pktPrivacy}\\" & strComputer & "\root\CIMV2")
	Set CreateWMIServiceInstance = objWMIService
	Write oLogFile, "Connected to " & strComputer,Err_NONE,bDebug

End Function

Function GetShareLocalPath(strShare,objWMIObject)
'===================================================
'	NAME:	GetShareLocalPath
'	IN:		strShare - Name of the Share
'			objWMIObject - WMI Service instance
'	OUT:	Local path to the folder
'	
'===================================================	
	Dim objShare
	Dim strSharePath
	Set objShare = objWMIObject.Get("Win32_Share='" & strShare &"'")
	GetShareLocalPath = objShare.Path

End Function

Function GetFolderObject(strPath,objWMIObject)
'===================================================
'	NAME:	GetFolderObject
'	IN:		strPath - full path of folder to connect to
'			objWMIObject - WMI Service instance
'	OUT:	Instance of Win32_LogicalFileSecuritySetting class
'	
'===================================================	
	Dim objFlder
	Set objFlder = objWMIObject.Get("Win32_LogicalFileSecuritySetting='" & strPath &"'")
	Set GetFolderObject = objFlder

End Function


Function GetSecDesc(objIn)
'===================================================
'	NAME:	GetSecDesc
'	IN:		objIn - Instance of Win32_LogicalFileSecuritySetting
'					or Win32_LogicalShareSecuritySetting
'	OUT:	SecurtyDescriptor object for the folder
'			to set permissions on
'===================================================	
	Dim objTemp
	Dim nRet
	Dim strErr
	nRet = objIn.GetSecurityDescriptor(objTemp)
	If nRet <> 0 Then
		strErr = "GetSecurityDescriptor failed with following error code: " 
		Select Case nRet
			Case 2
				strErr = strErr & nRet & " : Access Denied"
			Case 8
				strErr = strErr & nRet & " : Unknown Failure"
			Case 9
				strErr = strErr & nRet & " : Privilege Missing"
			Case 21
				strErr = strErr & nRet & " : Invalid Parameter"
		End Select
		Write oLogFle,stdErr,Err_FAIL,bDebug
		Finalize oLogFile, tStart
		WScript.Quit 
	End If
	Set GetSecDesc = objTemp
End Function

Function CreateAce(objIn,strTrustee,strDomain,nAccMask,nAceFlag)
'===================================================
'	NAME:	CreateAce
'	IN:		objIn - Instance of WMI \Root\CIMV2 namespace
'			strTrustee - User or Group name
'			strDomain - Domain or Computer Name
'			nAccMask - AccessMask bit mask
'			nAceFlag - Ace Flag bitmask
'	OUT:	AccessControlEntry object
'===================================================	
	'Delcare variables
	Dim objAcct
	Dim objAccts
	Dim objSID
	Dim objTrustee
	Dim objACE
	dim strClass
	'Determines Win32_account class to use
	strClass = getClass(strTrustee,strDomain)
	'WScript.Echo strClass
	'Fetch a reference to the account for the trustee
	Set objAccts = objIn.ExecQuery("SELECT * FROM Win32_" & strClass & " WHERE Domain='" & strDomain & "' AND Name='" & strTrustee & "'",,48)
	'Fetch a reference to teh SID object for the account
	For Each objAcct In objAccts
		strSID = objAcct.SID
	Next
	Set objSID = objIn.get("Win32_SID='" & strSID & "'")
'Create a trustee object
	Set objTrustee = objIn.get("Win32_Trustee")
	objTrustee.Domain    = objSID.ReferencedDomainName
	objTrustee.Name      = objSID.AccountName
	objTrustee.SID       = objSID.BinaryRepresentation
	objTrustee.SidLength = objSID.SidLength
	objTrustee.SIDString = objSID.SID
		
' 	'Create an AccessControlEntry(ACE)
	Set objACE = objIn.get("Win32_ACE")
	objACE.Trustee = objTrustee
	objACE.AccessMask = nAccMask
	objACE.AceType = ACCESS_ALLOWED_ACE_TYPE
	objACE.AceFlags = nAceFlag
	
	Set CreateAce = objACE

End Function

Function getClass(strTrustee,strComputerName)
'===================================================
'	NAME:	getClass
'	IN:		strTrustee - User or Group name
'			strComputerName - Domain or Computer Name
'	OUT:	Class of Win32_account to use
'===================================================	
	Dim oTemp
	Dim strClass
	'Special case for 'SYSTEM' account
	If strTrustee = "SYSTEM" Then 
		strClass = "SystemAccount"
		getClass = strClass
		Exit Function
	Else
		'get trustee account object
		Set oTemp = GetObject("WinNT://" & strComputerName & "/" & strTrustee)
		If IsObject(oTemp) Then
			'Determine if User or Group
			strClass = oTemp.class
			'if user, set to Win32 name
			If strClass = "User" Then strClass = "UserAccount"
			getClass = strClass
		Else
			WScript.Echo "Object not found for Trustee. Returnvalue was (" & Err.number & ", " & Err.Description & ")"
			WScript.Quit
		End If
	End if
End Function


